-- invisible helper - no localization?

-- PhysX GUI for Ragdoll
global PxSelectBoneDialogResult = #()
global PxSelectBoneDialogList = #()

fn PxPrintExtraShapes n =
(
	modRB = PxGetModRB n
	if modRB != undefined and modRB.extraShapes != undefined then (
		strInfo = nvpxText.TXT_GUIRAGDOLL_INFO_EXTRA_SHAPE + n.name
		handles = filterString modRB.extraShapes ","
		for i in handles do (
			nd = PxGetNodeByHandle (i as integer)
			if nd != undefined then strInfo = strInfo + ", '" + nd.name + "'"
		)
		print strInfo
	)
)

fn PxSelectBonesDialog all selected =
(
	PxSelectBoneDialogResult = #()
	PxSelectBoneDialogList = #()
	
	--format " all = %\n" all
	--format " selected = %\n" selected
	for i in all do 
	(
		flag = true
		for j in selected do 
		(
			if i == j then 
			(
				flag = false
				exit
			)
		)
		if flag then append PxSelectBoneDialogList i
	)
	--format " PxSelectBoneDialogList = %\n" PxSelectBoneDialogList
	
	rollout PxSelectBonesDialogPanel "Select Bones"
	(
		label          ui_lbl1     "Select Bones"
		MultiListBox   ui_bones    ""             align:#left   height:10
		
		button         ui_ok       "Ok"           align:#left  offset:[10, 10] width:50 across:2
		button         ui_cancel   "Cancel"       align:#right offset:[0, 10] width:50
		
		on PxSelectBonesDialogPanel open do
		(
			--format " open PxSelectBoneDialogList = %\n" PxSelectBoneDialogList
			items = #()
			for i in PxSelectBoneDialogList do (
				append items i.name
			)
			ui_bones.items = items
		)
		
		on ui_ok pressed do 
		(
			for i in ui_bones.selection do (
				append PxSelectBoneDialogResult PxSelectBoneDialogList[i].inode.handle
			)
			DestroyDialog PxSelectBonesDialogPanel
		)
		
		on ui_cancel pressed do
		(
			DestroyDialog PxSelectBonesDialogPanel
		)
	)
	
	CreateDialog PxSelectBonesDialogPanel modal:true 
	PxSelectBoneDialogResult
)

plugin helper nvRagdoll
name:nvpxText.TXT_RAGDOLL_NAME
category:nvpxText.TXT_CATEGORY
invisible: true
classID:#(0x467579ab, 0x5883063f)
extends:RagdollVisualizer replaceui:true
(
	local groupToken = ";"
	local boneToken = ","
	local mDisplayMesh = undefined;
	local mNeedRebuild = true;
	
	local mBoneNodes   = #();
	local mBoneHandles = #()
	local mBoneFlags = #()
	local mBoneGroupIDs = #()
	local mBoneJointHandles = #()
	
	local mReactorRagdoll = #()
	local mReactorHinge = #()
	
	local selectedBones = #();
	local mDisplayedBoneHandles = #();
	local mDisplayedBoneGroups = #();
	
	parameters ragdoll rollout:px_panel_ragdoll_creation
	(
	helpersize      type:#float     default: 10
	boneGroups      type:#string
	rootBone        type:#node
	ragdollNode     type:#node         -- it stores the skin mesh of the ragdoll
	rbType          type:#integer   default:1         ui:ui_rbType      
	meshType        type:#integer   default:1         --ui:ui_meshType    
	inflation       type:#float     default:0.0       ui:ui_inflation   
	weight          type:#float     default:0.5       ui:ui_weight
	-- joints store the handles of the joints; for each child RB, store the handle of its joint. if there is no joint, store 0. 
	-- Be carefull, a parent bone may have several joints. That is why here we use child RB
	joints          type:#string    
	)
	
	fn printInfo =
	(
		format nvpxText.TXT_GUIRAGDOLL_NODE_INFO_FMT mBoneNodes
		format nvpxText.TXT_GUIRAGDOLL_HANDLE_INFO_FMT mBoneHandles
		format nvpxText.TXT_GUIRAGDOLL_FLAG_INFO_FMT mBoneFlags
		format nvpxText.TXT_GUIRAGDOLL_GID_INFO_FMT mBoneGroupIDs
		format nvpxText.TXT_GUIRAGDOLL_GROUP_INFO_FMT boneGroups
	)
	
	fn loadAllBones initFromSelection:true =
	(
		mBoneNodes = #()
		if rootBone == undefined then
		(
			if initFromSelection == true and $selection[1] != undefined then
			(
				-- look for skin modifiers
				skinMod = $selection[1].modifiers["Skin"]
				if ragdollNode != undefined then skinMod = ragdollNode.modifiers["Skin"]
				
				if skinMod != undefined then
				(
					setCommandPanelTaskMode mode:#modify
					modPanel.setCurrentObject skinMod
					num = skinOps.GetNumberBones skinMod
					
					for i = 1 to num do
					(
						toto = skinOps.GetBoneName skinMod i 0
						obj = getnodebyname toto
						append mBoneNodes obj				
					)
				)
				else
				(
					format nvpxText.TXT_GUIRAGDOLL_ERR_UNKNOWN_RAG
				)
			)
		)
		else
		(
			allBones = #()
			
			t = findstring rootBone.name "bip"
			if t == undefined then append allBones rootBone   -- it is not biped bone.
			PxGetAllChildrenNodes rootBone allBones

			for i in allBones do 
			(
				--t = i.boneEnable or (classof(i) == Biped_Object) or PxIsRB(i)
				--if t then append mBoneNodes i
				if classof(i) != nvConstraint then append mBoneNodes i
			)
		)
	)
	
	fn initBoneGroups boneArray =
	(
		boneGroups = ""
		for i in boneArray do (
			boneGroups = boneGroups + groupToken + (i.inode.handle as string)
		)
	)
	
	fn parseJoints =
	(
		mBoneJointHandles = #()
		for i = 1 to mBoneNodes.count do (
			append mBoneJointHandles 0
		)
		if (joints == undefined) or (joints == "") then false
		else
		(
			strJoints = filterstring joints boneToken
			--format " mBoneNodes.count = %,  strJoints.count = %\n" mBoneNodes.count strJoints.count
			size = mBoneNodes.count
			if size > strJoints.count then size = strJoints.count
			for i = 1 to size do (
				mBoneJointHandles[i] = strJoints[i] as integer
			)
			true
		)
	)
	
	fn initBoneArrays initFromSelection:true =
	(
		mBoneHandles = #()
		mBoneFlags = #()
		mBoneGroupIDs = #()
		
		loadAllBones initFromSelection:initFromSelection
		for i in mBoneNodes do (
			append mBoneHandles i.inode.handle
			append mBoneFlags false
			append mBoneGroupIDs 0
			setuserprop i "isBone" true
		)
		
		parseJoints()
	)
	
	fn parseGroupsString =
	(
		if boneGroups == undefined then false
		else
		(
			selected = #()
			groups = filterString boneGroups groupToken
			groupCount = 1
			for i in groups do (
				items = filterString i boneToken
				for j in items do (
					for k = 1 to mBoneHandles.count do (
						if (j as integer) == mBoneHandles[k] then (
							mBoneGroupIDs[k] = groupCount
							mBoneFlags[k] = true
							exit
						)
					)
				)
				groupCount = groupCount + 1
			)
			true
		)
	)
	
	fn generateGroupsString =
	(
		boneGroups = ""
		groupCount = 1
		for i = 1 to mBoneFlags.count do (
			if mBoneFlags[i] then (
				if mBoneGroupIDs[i] != groupCount then (
					boneGroups = boneGroups + groupToken;
					groupCount = mBoneGroupIDs[i]
				)
				boneGroups = boneGroups + boneToken + (mBoneHandles[i] as string)
			)
		)
	)
	
	fn setNewHullForRB n modRB hull =
	(
		if hull == undefined then (
			modRB.meshType = PX_MESHTYPE_CAPSULE
			--modRB.physicalMesh = undefined
			format nvpxText.TXT_GUIRAGDOLL_NOTE_MORE_VERT (n.name)
		) else (
			--PxSetHull n hull
			--format " % set hull %, handl = %\n" n.name hull.name hull.handle
			hull.parent = n
			--modRB.physicalMesh = hull
		)
	)
	
	fn GetNodeVertices vertices boneNode =
	(
		tm = boneNode.transform
		for i = 1 to (getNumVerts boneNode.mesh) do (
			vert = (getVert boneNode.mesh i) * tm
			append vertices vert.x
			append vertices vert.y
			append vertices vert.z
		)
	)
	
	fn CreateConvexHullForGroupNode boneNode modRB =
	(
		--format " creating group convex hull for %\n" boneNode.name
		nodes = #()
		append nodes boneNode
		modRB.meshType = PX_MESHTYPE_CUSTOM
		handles = filterString modRB.extraShapes boneToken
		for i in handles do (
			n = PxGetNodeByHandle (i as integer)
			if n != undefined then append nodes n
		)
		hull = PX_CreateBoundingConvexForNodes nodes
		--setNewHullForRB boneNode modRB hull
	)

	fn GetBoneSkinVertices vertices ragdoll boneNode newPose=
	(
		tm = boneNode.transform * newPose
		isOk = nvpx.ParseSkinInfo ragdoll weight
		if isOk then (
			points = nvpx.GetVerticesFromSkinnedBone boneNode
			num = (points.count / 3) as integer
			for i = 1 to num do (
				pos = [points[i*3 - 2], points[i*3 - 1], points[i*3]]
				p = pos * tm
				append vertices p.x
				append vertices p.y
				append vertices p.z
			)
			--format " vertices.count = %, points.count = %\n" vertices.count points.count
		)
		--nvpx.ReleaseSkinInfo
	)

	fn CreateSkinHullForBone ragdoll boneNode modRB =
	(
		isOk = nvpx.ParseSkinInfo ragdoll weight
		if isOK then (
			vertices = nvpx.GetVerticesFromSkinnedBone boneNode
			hull = PX_CreateConvexHullFromPoints boneNode vertices modRB.meshVerticesLimit modRB.meshInflation
			--modRB.customMesh = hull
			if hull != undefined then
			(
				nvpx.SetRBMeshCustomNode boneNode 1 hull
				delete hull
				format nvpxText.TXT_GUIRAGDOLL_NEW_HULL_FMT (boneNode.name)
			)
			else
			(
				modRB.meshType = PX_MESHTYPE_CAPSULE
				--modRB.physicalMesh = undefined
				format nvpxText.TXT_GUIRAGDOLL_NOTE_MORE_VERT (boneNode.name)
			)
			--setNewHullForRB boneNode modRB hull
		)
	)
	
	fn CreateSkinHullForGroupNode ragdoll boneNode modRB =
	(
		vertices = #()
		newPose = Inverse(boneNode.transform)
		GetBoneSkinVertices vertices ragdoll boneNode newPose
		handles = filterString modRB.extraShapes boneToken
		for i in handles do (
			n = PxGetNodeByHandle (i as integer)
			if n != undefined then GetBoneSkinVertices vertices ragdoll n newPose
		)
		--format " %, %\n" vertices.count vertices
		hull = PX_CreateConvexHullFromPoints boneNode vertices modRB.meshVerticesLimit modRB.meshInflation
		--modRB.customMesh = hull
		if hull != undefined then
		(
			nvpx.SetRBMeshCustomNode boneNode 1 hull
			delete hull
			format nvpxText.TXT_GUIRAGDOLL_NEW_HULL_FMT (boneNode.name)
		)
		else
		(
			modRB.meshType = PX_MESHTYPE_CAPSULE
			--modRB.physicalMesh = undefined
			format nvpxText.TXT_GUIRAGDOLL_NOTE_MORE_VERT (boneNode.name)
		)
		--setNewHullForRB boneNode modRB hull
	)
	
	fn setJointPose joint parent child =
	(
		transform = child.transform
		joint.transform = transform
		joint.scale = [1,1,1]
	)
	
	fn createJoint nParent nChild =
	(
		ret = undefined
		modRBParent = PxGetModRB nParent
		modRBChild  = PxGetModRB nChild
		deleteJoint = false
		--format " createJoint:  %, %, %, %\n" nParent nChild modRBParent modRBChild
		if (modRBParent == undefined) or (modRBChild == undefined) and ((modRB.type == PX_PHYSTYPE_KINEMATIC) and (modRBChild.type == PX_PHYSTYPE_KINEMATIC)) then (
			deleteJoint = true
		)

		not_found = true
		for i = 1 to mBoneJointHandles.count while not_found do 
		(
			if mBoneNodes[i] == nChild then 
			(
				not_found = true
				if mBoneJointHandles[i] != 0 then 
				(
					if deleteJoint then 
					(
						n = PxGetNodeByHandle mBoneJointHandles[i]
						if n != undefined then delete n
						mBoneJointHandles[i] = 0
						ret = undefined
					) 
					else 
					(
						ret = PxGetNodeByHandle mBoneJointHandles[i]
					)
				) 
				else 
				(
					if deleteJoint then 
					(
						ret = undefined
					)
					else if nChild == rootBone then 
					(
						ret = undefined
					)
					else
					(
						joint = nvConstraint()
						joint.Init()
						joint.helpersize = 1
						-- to set pose for joint; requirement US383.B.4.b.i
						--joint.transform = nChild.transform
						--joint.transform.row4 = nChild.transform.row4
						setJointPose joint nParent nChild
						--joint.pos = nChild.transform.row4
						joint.parent  = nParent
						joint.body0   = nParent
						joint.body1   = nChild
						joint.swing1Mode = PX_DOF_LIMITED         -- limited
						joint.swing1Angle = 45
						joint.swing2Mode = PX_DOF_LIMITED
						joint.swing2Angle = 45
						joint.twistMode = PX_DOF_LOCKED           -- locked
						--joint.twistAngleLow = -45
						--joint.twistAngleHigh = 45
						mBoneJointHandles[i] = PxGetNodeHandle(joint)
						ret = joint
					)
				)
			)
		)
		ret
	)
	
	-- create RB only for a bone, does not create hull for the bone
	fn createRBForBone node =
	(
		collisionType = case meshType of
		(
		1: 3
		2: 4
		3: 6
		)
		interactivity = PX_PHYSTYPE_KINEMATIC
		if rbType == 2 then interactivity = PX_PHYSTYPE_DYNAMIC

		rb = PxGetModRB(node)
		createNew = false
		if rb == undefined then	(
			rb = PhysXModRB()
			createNew = true
		)
		if createNew then addmodifier node rb
		if (not rb.manualSetup) then rb.type = interactivity
		rb.meshType = collisionType
		if meshType == 3 then (
			rb.meshVerticesLimit = 32
			rb.meshInflation   = inflation
		)
	)
	
	fn flushRBType =
	(
		interactivity = PX_PHYSTYPE_KINEMATIC
		if rbType == 2 then interactivity = PX_PHYSTYPE_DYNAMIC
		max create mode
		for i = 1 to mBoneNodes.count do (
			if mBoneFlags[i] then (
				node = mBoneNodes[i]
				rb = PxGetModRB(node)
				if (rb != undefined) and (not rb.manualSetup) then rb.type = interactivity
			)
		)
		max modify mode
	)
	
	fn getParentRBNode node =
	(
		ret = undefined
		parent = node.parent
		while (parent != undefined and ret == undefined) do (
			modRB = PxGetModRB parent
			if modRB != undefined then ( ret = parent )
			else parent = parent.parent
		)
		ret
	)
	
	fn updateJointsString =
	(
		joints = ""
		for i in mBoneJointHandles do (
			joints = joints + (i as string) + boneToken
		)
	)
	
	fn deleteNodeByHandle handle =
	(
		joint = PxGetNodeByHandle handle
		if joint != undefined then delete joint
	)
	
	fn copyParamFromReactor jointNode =
	(
		ret = undefined
		if jointNode == undefined then ret = false
		else
		(
			for i in mReactorRagdoll while ret == undefined do (
				if ( (i.parentBody == jointNode.body0) and (i.childBody == jointNode.body1)) or ((i.childBody == jointNode.body0) and (i.parentBody == jointNode.body1)) then (
					--format " find jointNode % mataches reactor %\n" jointNode i
					--format " reactor params: tist(%, %), cone(%,%), plane(%,%)\n" i.twistMin i.twistMax i.coneMin i.coneMax i.planeMin i.planeMax
					jointNode.twistMode = PX_DOF_LIMITED  -- limited
					jointNode.twistAngleLow = i.twistMin
					jointNode.twistAngleHigh = i.twistMax
					jointNode.swing1Angle = (i.coneMax - i.coneMin)
					jointNode.swing2Angle = (i.planeMax - i.planeMin)
					jointNode.breakable = i.isBreakable
					ret = true
				)
			)

			for i in mReactorHinge while ret == undefined do (
				if ( (i.parentBody == jointNode.body0) and (i.childBody == jointNode.body1)) or ((i.childBody == jointNode.body0) and (i.parentBody == jointNode.body1)) then (
					--format " find jointNode % mataches reactor %\n" jointNode i
					jointNode.breakable = i.isBreakable
					jointNode.swing2Mode = PX_DOF_LOCKED
					-- need adjust those values
					if i.isLimited then jointNode.swing1Mode = PX_DOF_LIMITED else jointNode.swing1Mode = PX_DOF_FREE
					jointNode.swing1Angle = (i.maxLimitAngle - i.minLimitAngle)/2
					
					jointNode.swing1Mode = PX_DOF_LOCKED
					if i.isLimited then jointNode.twistMode = PX_DOF_LIMITED else jointNode.twistMode = PX_DOF_FREE
					jointNode.twistAngleLow = i.minLimitAngle
					jointNode.twistAngleHigh = i.maxLimitAngle
					ret = true
				)
			)
		)
		if ret == undefined do ret = false
		ret
	)
	
	fn copyParamFromFloatLimitControl jointNode =
	(
		ret = false
		if jointNode == undefined then false
		else
		(
			hasFloatLimit = nvpx.HaveBoneFloatLimitControl jointNode.body1 "x rotation"
			if(hasFloatLimit and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "x rotation" "enable") as booleanClass)) then (
				--format " %s has x rotation from float limit\n" jointNode
				ret = true
				if ((nvpx.GetBoneFloatLimitValue jointNode.body1 "x rotation" "upper_limit_enabled") as booleanClass) and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "x rotation" "upper_limit_enabled") as booleanClass) then (
					--format " set swing1Mode\n"
					jointNode.swing1Mode = PX_DOF_LIMITED
					highV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "x rotation" "upper_limit") as float
					lowV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "x rotation" "lower_limit") as float
					jointNode.swing1Angle = highV - lowV
				) 
			)
			hasFloatLimit = nvpx.HaveBoneFloatLimitControl jointNode.body1 "y rotation"
			if(hasFloatLimit and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "y rotation" "enable") as booleanClass)) then (
				--format " %s has y rotation from float limit\n" jointNode
				ret = true
				if ((nvpx.GetBoneFloatLimitValue jointNode.body1 "y rotation" "upper_limit_enabled") as booleanClass) and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "y rotation" "upper_limit_enabled") as booleanClass) then (
					--format " set swing2 Mode\n"
					jointNode.swing2Mode = PX_DOF_LIMITED
					highV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "y rotation" "upper_limit") as float
					lowV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "y rotation" "lower_limit") as float
					jointNode.swing2Angle = highV - lowV
				) 
			)
			hasFloatLimit = nvpx.HaveBoneFloatLimitControl jointNode.body1 "z rotation"
			if(hasFloatLimit and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "z rotation" "enable") as booleanClass)) then (
				--format " %s has z rotation from float limit\n" jointNode
				ret = true
				if ((nvpx.GetBoneFloatLimitValue jointNode.body1 "z rotation" "upper_limit_enabled") as booleanClass) and ((nvpx.GetBoneFloatLimitValue jointNode.body1 "z rotation" "upper_limit_enabled") as booleanClass) then (
					--format " set twistMode\n"
					jointNode.twistMode = PX_DOF_LIMITED
					highV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "z rotation" "upper_limit") as float
					lowV = (nvpx.GetBoneFloatLimitValue jointNode.body1 "z rotation" "lower_limit") as float
					jointNode.twistAngleLow = lowV
					jointNode.twistAngleHigh = highV
				) 
			)
			ret
		)
	)
	
	fn updateJoints =
	(
		--nodesToDelete = #()
		max create mode
		for i = 1 to mBoneNodes.count do 
		(
			b = mBoneNodes[i]
			modRB = PxGetModRB b
			parent = getParentRBNode b
			modParent = PxGetModRB parent
			if (modRB != undefined) and (modRB.type == PX_PHYSTYPE_DYNAMIC) and (parent != undefined) and (modParent.type != PX_PHYSTYPE_STATIC) then (
				joint = PxGetNodeByHandle mBoneJointHandles[i]
				if b != rootBone then (
					if parent != undefined then (
						joint = createJoint parent b
						mBoneJointHandles[i] = PxGetNodeHandle(joint)
					) else (
						mBoneJointHandles[i] = 0
					)
				) else (
					if joint.body0 != parent then (
						joint.body0 = parent
						setJointPose joint parent b
					)
				)
				if not copyParamFromReactor(joint) then copyParamFromFloatLimitControl(joint)
			) else (
				--format " delete joint handle %\n" mBoneJointHandles[i]
				deleteNodeByHandle mBoneJointHandles[i]
				mBoneJointHandles[i] = 0
			)
		)
		updateJointsString()
		max modify mode
	)
	
	fn createHullForBone node =
	(
		rb = PxGetModRB node
		isGroupNode = (rb.extraShapes != undefined) and (rb.extraShapes != "")
		if isGroupNode then CreateSkinHullForGroupNode ragdollNode node rb  else CreateSkinHullForBone ragdollNode node rb
	)

	fn updateRBForBone index interactivity collisionType manualMode=
	(
		node = mBoneNodes[index]
		rb = PxGetModRB(node)
		createNew = false
		if rb == undefined then	(
			rb = PhysXModRB()
			createNew = true
			rb.type = interactivity
		) else (
			if (not rb.manualSetup) then rb.type = interactivity
		)
		if (createNew) then addmodifier node rb
		rb.meshType = collisionType
		rb.manualSetup = manualMode
		if meshType == 3 then (
			rb.meshVerticesLimit = 32
			rb.meshInflation   = inflation
		)
		if collisionType == PX_MESHTYPE_CUSTOM then createHullForBone node
	)
		
	fn generateRBsForSelectedBones rows =
	(
		collisionType = case meshType of
		(
		1: 3
		2: 4
		3: 6
		)
		interactivity = PX_PHYSTYPE_KINEMATIC
		if rbType == 2 then interactivity = PX_PHYSTYPE_DYNAMIC

		max create mode
		items = rows as Array
		groupID = -1
		for i in items do (
			handle = mDisplayedBoneHandles[i]
			if handle == 0 then (
				-- it is group row, find its first node
				handle = mDisplayedBoneHandles[i + 1]
			)
			for j = 1 to mBoneNodes.count do (
				if mBoneHandles[j] == handle then (
					if mBoneFlags[j] then (
						updateRBForBone j interactivity collisionType true
					)
				)
			)
		)
		max modify mode
	)
	
	fn generateRBs =
	(
		--initBoneArrays()
		parseGroupsString()
		--printInfo()
		--format " generateRBs()\n"
		collisionType = case meshType of
		(
		1: 3
		2: 4
		3: 6
		)
		interactivity = PX_PHYSTYPE_KINEMATIC
		if rbType == 2 then interactivity = PX_PHYSTYPE_DYNAMIC
		--format " meshType = %\n" meshType
		max create mode
		groupID = -1
		for i = 1 to mBoneNodes.count do (
			group = mBoneGroupIDs[i]
			if groupID != group then (
				groupID = group
				--format " mBoneFlags[%] = %\n" i mBoneFlags[i]
				if mBoneFlags[i] then (
					updateRBForBone i interactivity collisionType false
				)
			)
		)
		--PxDeleteUselessHulls()
		max modify mode
	)
	
	fn deleteJoints =
	(
		--format " joints = %\n" mBoneJointHandles
		max create mode
		for i in mBoneJointHandles do (
			n = PxGetNodeByHandle i
			if n != undefined then delete n
		)
		max modify mode
	)
	
	fn deleteRBs =
	(
		--format " mBoneNodes = %\n" mBoneNodes
		max create mode
		for i in mBoneNodes do (
			--format " delete RB from %\n" i
			PxDeleteRB i
		)
		-- if it is biped and dynamic ragdoll, clear the keyframes.
		--if (classof(rootBone) == Biped_Object) and (rbType == 2) then  biped.clearAllAnimation rootBone.controller
		max modify mode
	)
	
	fn loadReactorNodes =
	(
		mReactorRagdoll = #()
		mReactorHinge = #()
		for i in objects do (
			if classof(i) == Ragdoll then (
				append mReactorRagdoll i
			) else if classof(i) == Hinge then (
				append mReactorHinge i
			)
		)
	)
	
	fn init ragHandle =
	(
		loadReactorNodes()
		if rootBone != undefined then (
			initBoneArrays()
			initBoneGroups(mBoneNodes)
			-- set user property
			if ragdollNode != undefined then (
				setuserprop rootBone     "RagdollMesh"       ragdollNode.inode.handle
			)
		)
	)
		
	fn boneStringToListViewRows v =
	(
		rows = #()
		mDisplayedBoneHandles = #()
		mDisplayedBoneGroups = #()
		groupCount = 1
		groups = filterString v groupToken
		for i in groups do (
			items = filterString i boneToken
			pad = ""
			if items.count > 1 then (
				pad = "  "
				append rows nvpxText.TXT_GUIRAGDOLL_GROUP
				append mDisplayedBoneHandles 0
				append mDisplayedBoneGroups (groupCount as integer)
			)
			for j in items do (
				t = PxGetNodeByHandle (j as integer)
				if t != undefined then (
					a = pad + t.name
					append rows a
					append mDisplayedBoneHandles (j as integer)
					append mDisplayedBoneGroups (groupCount as integer)
				)
		)
			groupCount = groupCount + 1
		)
		rows
	)
		 
	fn SkinIsUseless = 
	(
		ret = true
		nvpx.ParseSkinInfo ragdollNode weight
		for i = 1 to mBoneNodes.count while ret do (
			if mBoneFlags[i] then (
				number = nvpx.GetVerticesCountFromSkinnedBone mBoneNodes[i]
				if number > 3 then 
				(
					ret = false             -- skin is not useless
				)
			)
		)
		ret
	)
	
	rollout px_panel_ragdoll_creation "Ragdoll Creation"
	(
		group "Bones && Groups"
		(
		--activeXControl ui_bones    "{BDD1F04B-858B-11D1-B16A-00C0F0283628}" height:100 width:135 align:#left
		MultiListBox   ui_bones    ""           align:#left   height:10
		button ui_add              "Add"        align:#left   width:30  across:3
		button ui_remove           "Remove"     align:#right  width:55
		button ui_group            "Group"      align:#right  width:40
		)
		group "Rigid Body Type"
		(
		radiobuttons  ui_rbType        ""                 labels:#("Kinematic", "Dynamic (with Joints)")  width:130 columns:1 align:#left
		)
		group "Physical Mesh"
		(
		--radiobuttons   ui_meshType      ""                labels:#("Capsule", "Hulls from Bones", "From Skinned Mesh")  width:130 columns:1 align:#left
		radiobuttons   ui_meshType1     ""                labels:#("Capsule")            width:130 columns:1 align:#left  default:1
		radiobuttons   ui_meshType2     ""                labels:#("Hulls from Bones")   width:130 columns:1 align:#left  default:0
		radiobuttons   ui_meshType3     ""                labels:#("From Skinned Mesh")  width:130 columns:1 align:#left  default:0
		label          lbl_inflation    "Inflation"       align:#left across:2 offset:[15, 0]
		spinner        ui_inflation     ""                align:#right  type:#float range:[-10000, 10000, 0] scale:0.05 width:80
		label          lbl_weight       "Weight"          align:#left across:2 offset:[15, 0]
		spinner        ui_weight        ""                align:#right  type:#float range:[0, 1.0, 0] scale:0.05 width:80
		)
		button         ui_regenSelected  "Regenerate Selected Bone" align:#left  width:140
		button         ui_regenerate     "Regenerate Entire Ragdoll" align:#left  width:140
		
		on ui_rbType changed state do 
		(
			-- 
			interactivity = PX_PHYSTYPE_DYNAMIC
			if rbType == 1 then interactivity = PX_PHYSTYPE_KINEMATIC
			--
			for i in mBoneNodes do 
			(
				-- format " inside ui_rbType: %\n" (i.name)
				m = PxGetModRB i
				if m != undefined then
				(
					m.type = interactivity
				)
			)
			updateJoints()
		)
		
		fn enableMeshTypeButtons =
		(
			if ragdollNode != undefined then (
				m = ragdollNode.modifiers[#skin]
				if m == undefined then m = ragdollNode.modifiers[#Physique]
				ui_meshType3.enabled = (m != undefined)
			) else (
				ui_meshType3.enabled = false
			)
		)
		
		fn updateEnableState = 
		(
			lbl_inflation.enabled = (meshType == 3)
			ui_inflation.enabled = (meshType == 3)
			lbl_weight.enabled = (meshType == 3)
			ui_weight.enabled = (meshType == 3)
		)


		fn UpdateMeshTypeButtons w =
		(
			ui_meshType1.state = 0
			ui_meshType2.state = 0
			ui_meshType3.state = 0
			w.state = 1
			if ui_meshType1.state == 1 then (
				meshType = 1
			) else if ui_meshType2.state == 1 then (
				meshType = 2
			) else (
				meshType = 3
			)
			
			updateEnableState()
		)
		
		fn SetMeshTypeButtons =
		(
			ui_meshType1.state = 0
			ui_meshType2.state = 0
			ui_meshType3.state = 0
			case meshType of 
			(
			1: ui_meshType1.state = 1
			2: ui_meshType2.state = 1
			3: ui_meshType3.state = 1
			)
		)
		
		--on ui_meshType changed state do updateEnableState()
		on ui_meshType1 changed state do UpdateMeshTypeButtons(ui_meshType1)
		on ui_meshType2 changed state do UpdateMeshTypeButtons(ui_meshType2)
		on ui_meshType3 changed state do UpdateMeshTypeButtons(ui_meshType3)

		fn SkippedInSelection = 
		(
			ret = false
			items = ui_bones.selection as Array
			if items.count >= 1 then
			(
				prev = items[1]
				for i in items while nor ret do (
					if (i - prev) > 2 then ( ret = true )
					if (i - prev) == 2 then (
						if mDisplayedBoneHandles[prev + 1] != 0 then ( ret = true )
					)
					prev = i
				)
			)
			ret
		)
		
		fn GroupInSelection =
		(
			ret = false
			items = ui_bones.selection as Array
			if items.count >= 1 then (
				-- prevent the case that use selects a group row
				for i in items while not ret do (
					if mDisplayedBoneHandles[i] == 0 then ret = true
				)
			)
			ret
		)

		fn SelectValidBones rows =
		(
			ret = false
			items = rows as Array
			for i in items while not ret do (
				if i == 1 then ret = true
				else if mDisplayedBoneHandles[i] == 0 then ret = true
				else if i > 1 then (
					if mDisplayedBoneGroups[i - 1] != mDisplayedBoneGroups[i] then ret = true
					else if mDisplayedBoneHandles[i - 1] == 0 then ret = true
				)
			)
			ret
		)
		
		fn BoneSelectionChanged = 
		(
			ui_remove.enabled         = (ui_bones.selection.numberSet > 0)
			ui_regenSelected.enabled  = SelectValidBones ui_bones.selection
			ui_group.enabled          = (ui_bones.selection.numberSet > 1) and (not GroupInSelection()) and (not SkippedInSelection())
			if (ui_bones.selection.numberSet > 1) then (
				ui_regenSelected.text = nvpxText.TXT_GUIRAGDOLL_REGEN_BONES
			) else (
				ui_regenSelected.text = nvpxText.TXT_GUIRAGDOLL_REGEN_BONE
			)
		)
		
		on ui_bones selectionEnd do 
		(
			-- update prompt
			items = ui_bones.selection as Array
			if items.count >= 1 then (
				local str = "Selecting - "
				local sep = ""
				for i in items do
				(
					handle = mDisplayedBoneHandles[i]
					node = PxGetNodeByHandle handle
					if node != undefined then (str = str + sep + (node.name); sep = ", ")
				)
				replacePrompt str
				
				-- do selection change codes
				BoneSelectionChanged()
			)
		)
		
		on ui_bones selected v do 
		(
			replacePrompt nvpxText.TXT_GUIRAGDOLL_PROMPT_CREATE_RAG
		)
		
		on ui_bones doubleClicked v do 
		(
			handle = mDisplayedBoneHandles[v]
			node = PxGetNodeByHandle handle
			if node != undefined then select node
		)
		
		fn GetMaxGroupID =
		(
			groupID = 1
			for i in mBoneGroupIDs do (
				if groupID < i then groupID = i
			)
			groupID
		)
		
		fn GetGroupRootNode groupID =
		(
			rt = undefined
			not_found = true
			for i = 1 to mBoneGroupIDs.count while not_found do (
				if mBoneGroupIDs[i] == groupID then (
					if rt == undefined then rt = mBoneNodes[i]
					if mBoneFlags[i] then (
						rt = mBoneNodes[i]
						not_found = false
					)
				)
			)
			rt
		)

		fn BuildGroup groupID =
		(
			boneNum = 0
			for i = 1 to mBoneGroupIDs.count do (
				if mBoneGroupIDs[i] == groupID then (
					boneNum = boneNum + 1
				)
			)
			groupRoot = GetGroupRootNode groupID
			modRB = undefined 
			if groupRoot != undefined then modRB = PxGetModRB groupRoot
			if modRB != undefined then (modRB.extraShapes = "")

			if boneNum < 2 then false
			else
			(
				extraBones = ""
				for i = 1 to mBoneGroupIDs.count do (
					if mBoneGroupIDs[i] == groupID then (
						--format " groupRoot = %, %\n" groupRoot mBoneGroupIDs[i]
						if groupRoot != mBoneNodes[i] then (
							--format " PxDeleteRB mBoneNodes[i] = %\n" mBoneNodes[i]
							PxDeleteRB mBoneNodes[i]
							extraBones  = extraBones + boneToken + (mBoneNodes[i].inode.handle as string)
						)
					)
				)
				modRB = PxGetModRB groupRoot
				if modRB == undefined then (
					createRBForBone groupRoot
					modRB = PxGetModRB groupRoot
				)
				modRB.extraShapes = extraBones
				--format " groupRoot = %, extrashapes = %\n" groupRoot modRB.extraShapes
				
				createRBForBone groupRoot
				--PxPrintExtraShapes groupRoot
				true
			)
		)
		
		fn BuildSingleBone groupID =
		(
			for j = 1 to mBoneNodes.count do (
				if mBoneGroupIDs[j] == groupID then (
					modRB = PxGetModRB mBoneNodes[j]
					if modRB != undefined then modRB.extraShapes = ""
					createRBForBone mBoneNodes[j]
					exit
				)
			)
		)
		
		fn addBones boneToAdd =
		(
			boneList = #()
			initBoneArrays()
			parseGroupsString()
			effectedGroups = #()
			newGroupID = GetMaxGroupID() + 1
			for i in boneToAdd do (
				handle = (i as integer) 
				for k = 1 to mBoneHandles.count do (
					if handle == (mBoneHandles[k]) then (
						mBoneFlags[k] = true
						
						if (k > 1) and (k < mBoneHandles.count) and (mBoneGroupIDs[k - 1] == mBoneGroupIDs[k + 1]) and (mBoneGroupIDs[k - 1] != 0) then (
							mBoneGroupIDs[k] = mBoneGroupIDs[k - 1]
							append effectedGroups mBoneGroupIDs[k]
						) else (
							append boneList (PxGetNodeByHandle handle)
							mBoneGroupIDs[k] = newGroupID
							newGroupID = newGroupID + 1
						)
					)
				)
			)
			generateGroupsString()
			max create mode
			for i in effectedGroups do ( BuildGroup i )
			for i in boneList do (createRBForBone i)
			max modify mode
		)
		
		on ui_add pressed do
		(
			--printInfo()
			selectedBones = #()
			for i = 1 to mBoneFlags.count do (
				if mBoneFlags[i] then append selectedBones mBoneNodes[i]
			)
			t = PxSelectBonesDialog mBoneNodes selectedBones
			addBones t
			ui_bones.items = boneStringToListViewRows(boneGroups)
			BoneSelectionChanged()
			updateJoints()
			if (meshType == 3) and not SkinIsUseless() then (
			)
			--printInfo()
		)
		
		fn removeBones rows = 
		(
			items = rows as Array
			--format " rows to delete %\n" items
			effectedGroups = #()
			groupsToDelete = #()
			bonesToDelete = #()
			boneList = #()
			for i in items do (
				if mDisplayedBoneHandles[i] == 0 then (
					append groupsToDelete mDisplayedBoneGroups[i]
				)
				--format " process node handle %\n" mDisplayedBoneHandles[i]
				for j = 1 to mBoneNodes.count do (
					if mDisplayedBoneHandles[i] == mBoneHandles[j] then (
						append effectedGroups mBoneGroupIDs[j]
						mBoneFlags[j] = false
						mBoneGroupIDs[j] = 0
						append bonesToDelete mBoneNodes[j]
						--format " delete RB for handle = %, mBoneFlags[%] = %, mBoneGroupIDs = %\n" mBoneHandles[j] j mBoneFlags[j] mBoneGroupIDs[j]
						--format " delete RB for handle = %, %\n" mBoneHandles[j] mBoneNodes[j].name
					) 
				)
			)
			--printInfo()
			--format " groupsToDelete = %\n" groupsToDelete
			--format " effectedGroups = %\n" effectedGroups
			firstGroupBone = undefined
			newGroupID = GetMaxGroupID() + 1
			deletedGroupRootNodes = #()
			for i in groupsToDelete do (
				groupRoot = GetGroupRootNode i
				if groupRoot !=undefined then append deletedGroupRootNodes groupRoot
				for j = 1 to mBoneGroupIDs.count do (
					if i == mBoneGroupIDs[j] then (
						mBoneGroupIDs[j] = newGroupID
						append boneList mBoneNodes[j]
						newGroupID = newGroupID + 1
					)
				)
			)
			generateGroupsString()
			--printInfo()
			--format " boneList = %\n" boneList
			max create mode
			for i in deletedGroupRootNodes do (
				--format " try to update group root node %\n" groupRoot
				modRB = PxGetModRB i
				if modRB != undefined then (modRB.extraShapes = "")
			)

			for i in bonesToDelete do (PxDeleteRB i)
			for i in effectedGroups do ( 
				if not BuildGroup(i) then (
					-- it is a single node
					BuildSingleBone i
				)
			)
			for i in boneList do (createRBForBone i)
			--printInfo()
			max modify mode
		)
		
		on ui_remove pressed do
		(
			--printInfo()
			--initBoneArrays()
			--parseGroupsString()
			removeBones ui_bones.selection
			ui_bones.items = boneStringToListViewRows(boneGroups)
			BoneSelectionChanged()
			if (meshType == 3) and SkinIsUseless() then (
				ui_meshType1.state = 1
				meshType = 1
				generateRBs()
			)
			updateJoints()
			--printInfo()
		)
		
		fn GroupBones rows =
		(
			items = rows as Array
			groupsToUpdate = #()
			groupID = -1
			newGroupID = GetMaxGroupID() + 1
			--format " mBoneGroupIDs = %\n" mBoneGroupIDs
			prevGroup = -1
			lastOne = -1
			for i in items do (
				if groupID != mDisplayedBoneGroups[i] then (
					groupID = mDisplayedBoneGroups[i]
					append groupsToUpdate groupID
				)			
				if mDisplayedBoneHandles[i] != 0 then (
					for j = 1 to mBoneNodes.count do (
						if mBoneHandles[j] == mDisplayedBoneHandles[i] then 
						(
							mBoneGroupIDs[j] = newGroupID
							if prevGroup < 0 then (
								if j > 2 then (
									prevGroup = mBoneGroupIDs[j - 1]
								)
							)
							lastOne = j
							exit
						)
					)
				)
			)
			--format " prevGroup is %\n" prevGroup
			--format " last one is %\n" mBoneNodes[lastOne].name
			--format " mBoneGroupIDs = %\n" mBoneGroupIDs
			generateGroupsString()
			-- remove RBs from member bones
			--printInfo()
			--format " groupsToUpdate = %\n" groupsToUpdate
			--format " new groupID = %\n" newGroupID
			max create mode
			BuildGroup newGroupID
			-- process previus group
			if prevGroup > 0 then (
				--format " need process prev group %\n" nextGroup
				if not BuildGroup(prevGroup) then (
					-- it is a sigle bone
					BuildSingleBone(prevGroup)
				)
			)
			-- precess next group
			if lastOne > 0 and lastOne < mBoneNodes.count then (
				nextGroup = mBoneGroupIDs[lastOne + 1]
				--format " need process next group %\n" mBoneNodes[lastOne + 1].name
				if not BuildGroup(nextGroup) then (
					BuildSingleBone(nextGroup)
				)
			)
			max modify mode
		)
		
		on ui_group pressed do
		(
			--printInfo()
			GroupBones ui_bones.selection
			ui_bones.items = boneStringToListViewRows(boneGroups)
			BoneSelectionChanged()
			updateJoints()
			--printInfo()
		)
		
		on ui_regenSelected pressed do
		(
			generateRBsForSelectedBones(ui_bones.selection)
			updateJoints()
		)
		
		on ui_regenerate pressed do
		(
			generateRBs()
			updateJoints()
			format nvpxText.TXT_GUIRAGDOLL_GEN_DONE
		)

		on px_panel_ragdoll_creation open do
		(
			initBoneArrays()
			parseGroupsString()
			if boneGroups != undefined then ui_bones.items = boneStringToListViewRows(boneGroups)
			ui_group.enabled = false
			enableMeshTypeButtons() 
			updateEnableState()
			BoneSelectionChanged()
			SetMeshTypeButtons()
			pushPrompt nvpxText.TXT_GUIRAGDOLL_PROMPT_CREATE_RAG
		)
		
		on px_panel_ragdoll_creation close do
		(
			popPrompt()
		)
	)

	tool create
	(
		on mousepoint click do
		case click of
		(
			1: 
			(
				nodeTM.translation = worldpoint;
				--delegate.boxsize = [3, 3, 3];
				#stop
			)
		)
	)
)

-- initialize Ragdolls after opening a Max file
fn PxRagFilePostOpen =
(
	global PxRagdollList
	for i in objects do
	(
		if (classof(i) == nvRagdoll) then 
		(
			i.initBoneArrays initFromSelection:false
		)
		else if (classof(i) == RagdollHelper) then
		(
			appendIfUnique  PxRagdollList i
		)
	)
)

-- use this to delete a ragdoll helper when 
-- TO DO: Refactor to improve performance.

if PHYSX_AUTODESK_VER==undefined do  -- Disabled in Autodesk version due to performance problem
fn PxRagNodePreDelete =
(
	global PxRagdollList
	node = callbacks.notificationParam()

	if IsValidNode(node) then
	(
		--format "PxRagNodePreDelete()\n"
		rootBone = node
		neadClearOthers = true
		if( classof(node) == RagdollHelper ) then
		(
			rootBone = node.rootBone
			index = findItem PxRagdollList node
			if index != 0 then
				deleteItem PxRagdollList index
			
			node.removeJoints()
			if (rootBone == undefined) then 
			(
				neadClearOthers = false
			)		
		)
		if (neadClearOthers) then
		(
			todelete = #()
			for i in PxRagdollList do
			(
				if IsValidNode(i) and (i != node) and (i.rootBone == rootBone) do
				(
					appendIfUnique todelete i
				)
			)
			for i in todelete do
			(
				i.rootbone = undefined
				index = findItem PxRagdollList i
				deleteItem PxRagdollList index
				delete i
			)
		)
	)
)
callbacks.removeScripts id:#PhysXPluginRagdoll
if PHYSX_AUTODESK_VER==undefined do  -- Disabled in Autodesk version due to performance problem
	callbacks.addScript #nodePreDelete  "PxRagNodePreDelete()" id:#PhysXPluginRagdoll
callbacks.addScript #filePostOpen   "PxRagFilePostOpen()" id:#PhysXPluginRagdoll